# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, specifically (robot-at floor).
        # We will attempt to use available skills to explore and confirm the robot's location.

        # The available skills are:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper']

        # We will use 'execute_go' to move the robot and check if the predicate (robot-at floor) is updated.
        # Since we do not have the exact object and location names, we will attempt to use the keys from positions.

        # Try to find a location named 'floor' in the positions dictionary
        floor_location = None
        for key in positions:
            if 'floor' in key.lower():
                floor_location = key
                break

        # If not found, just pick any location as a fallback
        if floor_location is None:
            for key in positions:
                if 'location' in key.lower() or 'room' in key.lower():
                    floor_location = key
                    break

        # If still not found, just pick the first key
        if floor_location is None and len(positions) > 0:
            floor_location = list(positions.keys())[0]

        # For demonstration, print the chosen floor location
        print(f"[Exploration] Using floor location: {floor_location}")

        # Now, try to execute 'execute_go' to the floor location if possible
        # We need to know the current robot location; let's assume it's in the observation or positions
        # For this example, we will try to move from the current location to the floor location

        # Attempt to find the robot's current location
        robot_current_location = None
        for key in positions:
            if 'robot' in key.lower() or 'start' in key.lower():
                robot_current_location = key
                break
        if robot_current_location is None and len(positions) > 0:
            robot_current_location = list(positions.keys())[0]

        # If the robot is already at the floor location, skip moving
        if robot_current_location == floor_location:
            print(f"[Exploration] Robot is already at {floor_location}.")
        else:
            try:
                print(f"[Exploration] Moving robot from {robot_current_location} to {floor_location} using execute_go.")
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location=robot_current_location,
                    to_location=floor_location,
                    max_steps=100,
                    threshold=0.01,
                    timeout=10.0
                )
                print(f"[Exploration] Robot moved to {floor_location}.")
            except Exception as e:
                print(f"[Exploration] Failed to execute_go: {e}")

        # After moving, check if the predicate (robot-at floor) is now true
        # This would be part of the observation or state; for now, just print a message
        print(f"[Exploration] Check if (robot-at {floor_location}) is now true in the state.")

        # === End of Exploration Phase ===

        # TODO: Continue with further task steps or exploration as needed.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()