from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Place one dice into the open drawer, following domain and initial state constraints.
    """
    robot = RobotController()

    # Step 1: If the room is dark, turn on the light
    # (room-dark) in initial state, so must push the light switch first
    robot.execute_movement(Object["light_switch"], mode=1)

    # Step 2: Move to the ready pose (if not already there)
    robot.execute_movement(Object["drawer_top_place_left"], mode=8)

    # Step 3: Pick up dice1 from the floor at ready-pose (axis=2 for z-axis pick)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 4: Place dice1 into drawer1 (drawer1 is already open and unlocked)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # Optionally, return to ready pose
    robot.execute_movement(Object["drawer_top_place_left"], mode=8)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()