"""Insert one dice (dice1) into the open drawer (drawer1) as per the current world state and domain constraints."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to insert dice1 into the open drawer1, following domain preconditions."""
    robot = RobotController()

    try:
        # Step 1: Move to the light switch location to turn on the light if the room is dark
        robot.execute_movement(Object["light_switch_location"], mode=0)
        robot.execute_push_switch(Object["light_switch"])

        # Step 2: Move to the ready-pose location (where dice1 is on the floor)
        robot.execute_movement(Object["ready_pose"], mode=0)

        # Step 3: Pick up dice1 from the floor (z-axis)
        robot.execute_pick(Object["dice1"], axis=2)

        # Step 4: Move to the drawer-area location (where drawer1 is open)
        robot.execute_movement(Object["drawer_area"], mode=0)

        # Step 5: Place dice1 into the open drawer1 (z-axis)
        robot.execute_place(Object["dice1"], Object["drawer1"], axis=2)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()