"""Module to place one dice into the open drawer, ensuring the light is on as required by the domain."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Executes the sequence to place one dice into the open drawer."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_movement(Object["light_switch"], mode=3, axis=0)

    # Step 2: Pick up a dice (choose dice1 if available, else dice2)
    dice_to_pick = "dice1" if "dice1" in Object else "dice2"
    robot.execute_movement(Object[dice_to_pick], mode=1, axis=2)

    # Step 3: Place the dice into the open drawer (choose any open drawer, here drawer1)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

def main():
    """Main function to execute the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()