"""Module to put a single dice in an already open drawer, ensuring domain preconditions."""
from Object_list import Object
from skill_mapping import RobotController

def put_single_dice_in_open_drawer():
    """Put any single dice into an already open drawer, ensuring light is on and preconditions are met."""
    robot = RobotController()

    # Step 1: Ensure the room is bright (turn on the light if needed)
    robot.execute_movement(Object["light_switch"], mode=5)  # Mode 5: push switch to turn on light

    # Step 2: Select any dice on the floor
    dice_candidates = [name for name in Object if name.startswith("dice") and Object[name].location == "floor"]
    if not dice_candidates:
        print("No dice found on the floor.")
        return
    dice_name = dice_candidates[0]

    # Step 3: Select any open drawer
    open_drawers = [name for name in Object if name.startswith("drawer") and Object[name].state == "open"]
    if not open_drawers:
        print("No open drawer found.")
        return
    drawer_name = open_drawers[0]

    # Step 4: Move to the dice location and pick it up
    robot.execute_movement(Object[dice_name], mode=8)  # Move to dice location (ready pose)
    robot.execute_movement(Object[dice_name], mode=1, axis=2)  # Pick up dice along z-axis

    # Step 5: Move to the open drawer and place the dice inside
    robot.execute_movement(Object[drawer_name], mode=8)  # Move to drawer (ready pose)
    robot.execute_movement(Object[drawer_name], mode=2, axis=2)  # Place dice into drawer

def main():
    """Main entry point to execute the dice placement task."""
    put_single_dice_in_open_drawer()

if __name__ == "__main__":
    main()