from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Put a single dice in the already open drawer.
    Preconditions: If the room is dark, turn on the light. Robot starts at ready-pose.
    """
    robot = RobotController()

    # Step 1: If the room is dark, turn on the light
    if robot.is_room_dark():
        robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Ensure robot is at ready-pose
    if not robot.is_at_location(Object["ready-pose"]):
        robot.execute_go(Object["robot-current-location"], Object["ready-pose"])

    # Step 3: Pick up any dice on the floor (dice1 or dice2)
    dice_to_use = None
    for dice_name in ["dice1", "dice2"]:
        if robot.is_on_floor(Object[dice_name]):
            dice_to_use = dice_name
            break

    if dice_to_use is None:
        raise RuntimeError("No dice available on the floor to pick up.")

    robot.execute_pick(Object[dice_to_use], Object["ready-pose"])

    # Step 4: Place the dice into the already open drawer1 at ready-pose
    robot.execute_place(Object[dice_to_use], Object["drawer1"], Object["ready-pose"])

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()