"""Module to store a dice in the open drawer, ensuring all domain preconditions are satisfied."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store a dice in the open drawer, handling lighting and location."""
    robot = RobotController()
    try:
        # Step 1: Move to light switch location if not already there
        robot.execute_movement(Object["light_switch"], mode=0)
        # Step 2: Turn on the light
        robot.execute_push_switch(Object["light_switch"])
        # Step 3: Move to ready-pose (where dice1 is located)
        robot.execute_movement(Object["ready-pose"], mode=0)
        # Step 4: Pick up dice1 from ready-pose
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 5: Place dice1 into drawer1 at ready-pose (drawer1 is already open)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()