from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Move two dice to the drawer that's already open.
    Plan (from specification):
      1. execute_go(robot_current_location, dice1_location)
      2. execute_pick(dice1, dice1_location)
      3. execute_go(dice1_location, open_drawer_location)
      4. execute_place(dice1, open_drawer, open_drawer_location)
      5. execute_go(open_drawer_location, dice2_location)
      6. execute_pick(dice2, dice2_location)
      7. execute_go(dice2_location, open_drawer_location)
      8. execute_place(dice2, open_drawer, open_drawer_location)
    """

    robot = RobotController()

    try:
        # Step 1: Move to dice1 location
        robot.execute_movement(Object["dice1"], mode=7)
        # Step 2: Pick up dice1 (approach along z-axis: axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 3: Move to open drawer location (use drawer_top_place_left for dice1)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        # Step 4: Place dice1 into open drawer (approach along z-axis: axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Move to ready pose after place
        robot.execute_movement(mode=8)

        # Step 5: Move to dice2 location
        robot.execute_movement(Object["dice2"], mode=7)
        # Step 6: Pick up dice2 (approach along z-axis: axis=2)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 7: Move to open drawer location (use drawer_top_place_right for dice2)
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)
        # Step 8: Place dice2 into open drawer (approach along z-axis: axis=2)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        # Move to ready pose after place
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during oracle sequence execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()