from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle_bottom (execute_pick)
        # According to the specification, when grasping handles, approach along the x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull the drawer_bottom using handle_bottom (execute_pull)
        # For pulling, also approach along the x-axis (axis=0), and set a reasonable pull distance
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()