from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 0: (Optional) Turn on the light if the room is dark (execute_push_switch)
        # Not implemented as a skill in the provided RobotController, so we skip this step.
        # If available, it would be something like:
        # robot.execute_movement(Object["light_switch"], mode=...) 

        # Step 1: Pick the handle_bottom at ready-pose (execute_pick)
        # For handles, approach axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull the drawer_bottom using handle_bottom at ready-pose (execute_pull)
        # For pulling, approach axis=0 (x-axis), use a longer distance for drawer opening
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()