from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the handle_bottom (for drawer_bottom) at ready-pose
        # According to the axis convention: for handles, use axis=0 (x-axis approach)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull the drawer_bottom using the handle_bottom at ready-pose
        # For pulling, use mode=4, axis=0 (x-axis approach), and a reasonable distance (e.g., 0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()