from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_push_switch(light_switch, ready-pose)
        # (Turn on the light at the ready-pose location)
        # Go to ready pose if needed
        robot.execute_movement(Object.get("ready-pose", None), mode=8)
        # Push the light switch (simulate execute_push_switch)
        # Since there is no direct skill for execute_push_switch, we use the push primitive on the light switch.
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=2, distance=0.03)

        # Step 2: execute_pick(handle_bottom, ready-pose)
        # (Pick up the bottom drawer handle from ready-pose, approach along x-axis)
        robot.execute_movement(Object.get("handle_bottom", None), mode=1, axis=0)

        # Step 3: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # (Pull open the bottom drawer using the handle, approach along x-axis)
        # For execute_pull, we use the handle's pose for the movement, as that's what the robot will grasp.
        robot.execute_movement(Object.get("handle_bottom", None), mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()