from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light (execute_push_switch)
        # There is no direct mode for execute_push_switch in the skill mapping.
        # As a workaround, move to the light switch position (if available), then open/close gripper to simulate interaction if needed.
        # Here, we use go_to_ready_pose (mode=8) to ensure the robot is in a safe pose before/after.
        robot.execute_movement(Object.get("light_switch", Object["drawer_bottom_handle"]), mode=8)

        # Step 2: Pick the bottom drawer handle (execute_pick), approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the bottom drawer using the handle (execute_pull), approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()