from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_push_switch on "light_switch" at "ready-pose"
    try:
        light_switch_pose = Object.get("light_switch", None)
        if light_switch_pose is None:
            raise ValueError("Pose for 'light_switch' not found in Object_list.")
        robot.execute_movement(light_switch_pose, mode=3, axis=2)
    except Exception as e:
        print(f"Error in execute_push_switch for light_switch: {e}")

    # Step 2: execute_pick on "drawer_bottom_handle" at "ready-pose"
    try:
        drawer_bottom_handle_pose = Object.get("drawer_bottom_handle", None)
        if drawer_bottom_handle_pose is None:
            raise ValueError("Pose for 'drawer_bottom_handle' not found in Object_list.")
        # For picking a handle, approach along the x-axis (axis=0)
        robot.execute_movement(drawer_bottom_handle_pose, mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_bottom_handle: {e}")

    # Step 3: execute_pull on "drawer_bottom" using "drawer_bottom_handle" at "ready-pose"
    try:
        # For pulling the drawer, use the handle's pose and approach along the x-axis (axis=0)
        if drawer_bottom_handle_pose is None:
            drawer_bottom_handle_pose = Object.get("drawer_bottom_handle", None)
            if drawer_bottom_handle_pose is None:
                raise ValueError("Pose for 'drawer_bottom_handle' not found in Object_list.")
        robot.execute_movement(drawer_bottom_handle_pose, mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom using drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()