from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light switch at ready-pose (execute_push_switch)
    try:
        # There is no direct mode for execute_push_switch in the provided skill mapping,
        # so we use the closest available: mode=3 (push) with the light switch pose.
        # If a dedicated function existed, it would be called here.
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=2, distance=0.03)
    except Exception as e:
        print(f"Error during execute_push_switch on light_switch: {e}")

    # Step 2: Pick the bottom handle at ready-pose (execute_pick, axis=0 for handle grasp)
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    # Step 3: Pull the bottom drawer using the handle at ready-pose (execute_pull, axis=0, distance=0.1)
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()