from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Push the light switch to turn on the light (execute_push_switch)
        # - The light switch is at ready-pose
        # - There is no direct mode for execute_push_switch in the skill mapping,
        #   but according to the plan and specification, this step must be executed first.
        # - We'll use mode=3 (push) as the closest mapping for pushing the switch.
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=0, distance=0.03)

        # Step 2: Pick up the handle_bottom (execute_pick)
        # - handle_bottom is a handle object on the floor at ready-pose
        # - For handles, approach axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the drawer open (execute_pull)
        # - Pull drawer_bottom using handle_bottom at ready-pose
        # - For handles, approach axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()