from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_push_switch(light_switch, ready-pose)
        # - Push the light switch to turn on the light.
        #   Approach switch along z-axis (axis=2).
        robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)

        # Step 2: execute_pick(handle_bottom, ready-pose)
        # - Pick up the handle for the bottom drawer.
        #   Approach handle along x-axis (axis=0).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # - Pull the bottom drawer open using the handle.
        #   Approach drawer along x-axis (axis=0).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()