# run_skeleton_task.py (Completed for Exploration of Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Find Missing Predicate (room-bright) ===
        # The feedback indicates that (room-bright) is a missing predicate.
        # According to the domain, (room-bright) is achieved by execute_push_switch.
        # We will attempt to execute execute_push_switch if the room is dark.

        # For this, we need to know the switch and the robot's location.
        # We'll try to infer these from the positions dictionary.

        # Try to find a switch and a location
        switch_name = None
        robot_location = None
        for name in positions:
            if 'switch' in name.lower():
                switch_name = name
            if 'robot' in name.lower() or 'robby' in name.lower():
                robot_location = positions[name]
        # If robot location is not found, try to find a location key
        if robot_location is None:
            for name in positions:
                if 'location' in name.lower() or 'room' in name.lower():
                    robot_location = positions[name]
                    break

        # If no switch found, just pick any object as switch for exploration
        if switch_name is None:
            for name in positions:
                if 'switch' in name.lower() or 'button' in name.lower():
                    switch_name = name
                    break
            if switch_name is None:
                # Fallback: pick any object
                switch_name = list(positions.keys())[0]

        # If no location found, pick any location
        if robot_location is None:
            robot_location = list(positions.values())[0]

        print(f"[Exploration] Trying to turn on the light using switch: {switch_name} at location: {robot_location}")

        # Try to execute the skill to turn on the light (room-bright)
        try:
            obs, reward, done = execute_push_switch(
                env,
                task,
                switch_name,
                robot_location
            )
            print("[Exploration] Executed execute_push_switch to achieve (room-bright).")
        except Exception as e:
            print(f"[Exploration] Failed to execute execute_push_switch: {e}")

        # === After Exploration: Continue with Task Plan ===
        # Now, the room should be bright. We can proceed with further actions if needed.
        # For demonstration, let's try to pick an object if available.

        # Find an object on the floor to pick
        object_to_pick = None
        for name in positions:
            if 'object' in name.lower() or 'ball' in name.lower() or 'cube' in name.lower():
                object_to_pick = name
                break
        if object_to_pick is None:
            # Fallback: pick any object that is not the switch
            for name in positions:
                if name != switch_name:
                    object_to_pick = name
                    break

        if object_to_pick is not None:
            print(f"[Task] Attempting to pick object: {object_to_pick} at location: {robot_location}")
            try:
                obs, reward, done = execute_pick(
                    env,
                    task,
                    object_to_pick,
                    robot_location
                )
                print(f"[Task] Successfully picked {object_to_pick}.")
            except Exception as e:
                print(f"[Task] Failed to pick {object_to_pick}: {e}")
        else:
            print("[Task] No suitable object found to pick.")

        # You can continue with further plan steps (e.g., place, pull, push, etc.) as needed,
        # using only the available skills and the information from positions.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
