# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We need to explore the environment to confirm the presence/absence of this predicate.

        # For exploration, we will use available skills to move the robot and observe the state.
        # Since only predefined skills can be used, we will use 'execute_go' to move the robot.

        # Try to move the robot to 'floor' location if it exists in positions
        # and observe if the predicate (robot-at floor) becomes true.

        # Find a location named 'floor' in the positions dictionary
        floor_location = None
        for key in positions:
            if 'floor' in key.lower():
                floor_location = key
                break

        # If 'floor' location is found, attempt to move the robot there
        if floor_location is not None:
            try:
                # Find current robot location
                robot_location = None
                for key in positions:
                    if 'robot' in key.lower():
                        robot_location = key
                        break

                if robot_location is not None and robot_location != floor_location:
                    print(f"[Exploration] Moving robot from {robot_location} to {floor_location} to check predicate (robot-at floor)")
                    # Use execute_go to move the robot
                    obs, reward, done = execute_go(
                        env,
                        task,
                        from_location=robot_location,
                        to_location=floor_location,
                        max_steps=100,
                        threshold=0.01,
                        timeout=10.0
                    )
                    print(f"[Exploration] Robot moved to {floor_location}. Check if (robot-at floor) holds in the state.")
                else:
                    print("[Exploration] Robot is already at the floor location or robot location not found.")
            except Exception as e:
                print(f"[Exploration] Exception during exploration move: {e}")
        else:
            print("[Exploration] No 'floor' location found in object positions.")

        # After exploration, you would typically check the state to see if (robot-at floor) is now true.
        # This can be done by examining the observation or state predicates if available.
        # For this skeleton, we simply print that the exploration step is complete.

        print("[Exploration] Exploration phase complete. If (robot-at floor) is now true, the missing predicate is confirmed.")

        # === End of Exploration Phase ===

        # TODO: Continue with the main oracle plan execution using available skills as needed.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
