# run_skeleton_task.py (Completed with Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We need to explore the environment to confirm the robot's location and update our knowledge.

        # For demonstration, let's assume the robot starts at 'floor' location.
        # We'll use the available skills to explore and confirm the robot's position.

        # The available skills are:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper', 'execute_push_swtich -> push']

        # Let's try to use 'execute_go' to move the robot and confirm its location.
        # Since we don't have the actual plan or object names, we'll use placeholders and try to handle errors gracefully.

        # Example exploration logic:
        robot_location = None
        try:
            # Try to find the robot's initial location from positions or observation
            # For this example, we assume 'floor' is a valid location
            if 'robot' in positions:
                robot_location = positions['robot']
            else:
                # Fallback: assume 'floor' is the starting location
                robot_location = 'floor'
        except Exception as e:
            print("[Exploration] Could not determine robot's initial position:", e)
            robot_location = 'floor'

        # Try to move the robot to another location (if any) to confirm movement works
        # For demonstration, let's assume there is another location called 'table'
        possible_locations = [key for key in positions.keys() if key != 'robot']
        if 'table' in possible_locations:
            target_location = 'table'
        elif len(possible_locations) > 0:
            target_location = possible_locations[0]
        else:
            target_location = None

        if target_location is not None:
            print(f"[Exploration] Attempting to move robot from {robot_location} to {target_location} using execute_go.")
            try:
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location=robot_location,
                    to_location=target_location,
                    max_steps=100,
                    threshold=0.01,
                    timeout=10.0
                )
                print(f"[Exploration] Robot moved to {target_location}.")
                robot_location = target_location
            except Exception as e:
                print(f"[Exploration] Failed to move robot: {e}")
        else:
            print("[Exploration] No other location found to move the robot.")

        # After exploration, we can confirm the predicate (robot-at floor) is required for further actions.
        # This exploration phase helps us identify and confirm the missing predicate.

        # === Main Task Plan Execution ===
        # Here, you would execute the oracle plan step-by-step using the available skills.
        # Since the actual plan and object names are not provided, this section is left as a placeholder.
        # Example:
        # try:
        #     obs, reward, done = execute_pick(env, task, obj='object_1', location=robot_location, ...)
        #     if done:
        #         print("[Task] Picked up object_1 successfully.")
        # except Exception as e:
        #     print(f"[Task] Failed to pick up object_1: {e}")

        # TODO: Insert oracle plan execution here using only predefined skills.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()