# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We need to explore the environment to confirm the robot's location and update our knowledge.

        # Try to use available skills to explore and identify the robot's location.
        # Since the available skills do not include a direct "explore" or "identify" action,
        # we will use the movement and observation skills to infer the missing predicate.

        # Step 1: Get all known locations from positions
        location_names = []
        for name, pos in positions.items():
            if 'floor' in name or 'room' in name or 'location' in name:
                location_names.append(name)
        # If no explicit location names, fallback to a default
        if not location_names:
            location_names = ['floor']

        # Step 2: Try to move the robot to each location and check if the robot is at that location
        # Use execute_go if available, otherwise just check the initial state
        # Since we have 'execute_go' in available skills, we can use it

        # For demonstration, let's assume the robot starts at the first location
        current_location = location_names[0]
        print(f"[Exploration] Assuming robot starts at location: {current_location}")

        # Try to move to other locations (if any) to confirm robot's ability to move
        for loc in location_names[1:]:
            try:
                print(f"[Exploration] Attempting to move robot from {current_location} to {loc} using execute_go")
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location=current_location,
                    to_location=loc,
                    max_steps=100,
                    threshold=0.01,
                    timeout=10.0
                )
                if done:
                    print(f"[Exploration] Robot successfully moved to {loc}")
                    current_location = loc
                else:
                    print(f"[Exploration] Robot failed to move to {loc}")
            except Exception as e:
                print(f"[Exploration] Exception during execute_go: {e}")

        # Step 3: After exploration, print out the robot's current location
        print(f"[Exploration] Robot is at location: {current_location}")
        print("[Exploration] If the predicate (robot-at floor) was missing, it should now be confirmed.")

        # === End of Exploration Phase ===

        # === (Optional) Continue with Oracle Plan Execution ===
        # Here you would continue with the actual plan steps using the available skills,
        # e.g., execute_pick, execute_place, etc., as required by your task.

        # Example (commented out, as actual plan is not provided):
        # try:
        #     obs, reward, done = execute_pick(env, task, obj_name, location, ...)
        #     if done:
        #         print("[Task] Picked up object successfully.")
        # except Exception as e:
        #     print(f"[Task] Exception during execute_pick: {e}")

        # TODO: Insert further plan logic here as needed.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()