# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We will use available skills to explore and check the effect of moving the robot.

        # The available skills are:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper']

        # We will attempt to use 'execute_go' to move the robot and observe the effect.
        # Since we do not have the exact object and location names, we will use the positions dictionary to infer them.

        # Try to find two different locations to move between
        location_names = [name for name, pos in positions.items() if 'floor' in name or 'room' in name or 'drawer' in name or 'table' in name or 'loc' in name]
        if len(location_names) < 2:
            # Fallback: just use all keys as possible locations
            location_names = list(positions.keys())

        # Select two distinct locations for exploration
        if len(location_names) >= 2:
            from_location = location_names[0]
            to_location = location_names[1]
        else:
            print("[Exploration] Not enough locations found for exploration.")
            from_location = None
            to_location = None

        # Try to execute the 'execute_go' skill to move the robot
        if from_location and to_location:
            print(f"[Exploration] Attempting to move robot from '{from_location}' to '{to_location}' using execute_go.")
            try:
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location,
                    to_location
                )
                print(f"[Exploration] execute_go completed. Robot should now be at '{to_location}'.")
            except Exception as e:
                print(f"[Exploration] Error during execute_go: {e}")
        else:
            print("[Exploration] Skipping execute_go due to insufficient location information.")

        # After moving, check if the predicate (robot-at <location>) is now true in the environment
        # This would confirm the missing predicate is (robot-at <location>)

        # Optionally, print out the current observation or state for debugging
        try:
            current_obs = task.get_observation()
            print("[Exploration] Current observation after execute_go:", current_obs)
        except Exception as e:
            print(f"[Exploration] Could not retrieve observation: {e}")

        # === End of Exploration Phase ===

        # TODO: After identifying the missing predicate, you can proceed to implement the oracle plan
        # using the available skills and the correct predicates.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()