"""Module to pull open a single drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def pull_open_single_drawer():
    """Pull open a single drawer."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Pick up a handle (e.g., handle_bottom) from the floor
    robot.execute_pick(Object["handle_bottom"], Object["ready-pose"])

    # Step 3: Pull open the corresponding drawer (e.g., drawer_bottom) using the handle
    robot.execute_pull(Object["drawer_bottom"], Object["handle_bottom"], Object["ready-pose"])

def main():
    """Main function to execute the pull open drawer task."""
    pull_open_single_drawer()

if __name__ == "__main__":
    main()