"""Module to uncover a drawer by opening it, following domain requirements."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to uncover (open) a drawer, ensuring lighting and preconditions."""
    robot = RobotController()

    try:
        # Step 1: Move to the light switch location and turn on the light if needed
        robot.execute_movement(Object["light_switch"], mode=1, axis=0)
        robot.execute_push_switch(Object["light_switch"], Object["light_switch_location"])

        # Step 2: Move to the handle of the bottom drawer
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pick the handle of the bottom drawer (handle_bottom)
        robot.execute_pick(Object["drawer_bottom_handle"], Object["drawer_bottom_handle_location"])

        # Step 4: Pull the bottom drawer open using the handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the drawer uncovering sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()