from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Pull open a single drawer (bottom drawer) following all domain preconditions.
    """
    robot = RobotController()

    try:
        # Step 1: Move to the light switch location and turn on the light if the room is dark
        robot.execute_movement(Object["light_switch"], mode=1, axis=0)
        robot.execute_push_switch(Object["light_switch"])

        # Step 2: Move to the bottom drawer area if not already there
        robot.execute_movement(Object["drawer_area"], mode=1, axis=0)

        # Step 3: Pick up the handle of the bottom drawer
        robot.execute_pick(Object["handle_bottom"])

        # Step 4: Pull to open the bottom drawer using the handle
        robot.execute_pull(Object["drawer_bottom"], Object["handle_bottom"])

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """
    Main entry point for pulling open a single drawer.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()