"""Module to slide open any one drawer, ensuring all necessary preconditions are met."""
from object_list import Object
from skill_mapping import RobotController

def slide_one_drawer_open():
    """Slides open any one closed and unlocked drawer, ensuring room is bright and robot is free."""
    robot = RobotController()

    # Step 1: Ensure the room is bright
    if robot.get_room_light_state() == "dark":
        robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Find a closed and unlocked drawer
    drawers = ["drawer_bottom", "drawer_middle", "drawer_top"]
    handles = {
        "drawer_bottom": "handle_bottom",
        "drawer_middle": "handle_middle",
        "drawer_top": "handle_top"
    }
    selected_drawer = None
    for drawer in drawers:
        if robot.is_drawer_closed(drawer) and robot.is_drawer_unlocked(drawer):
            selected_drawer = drawer
            break

    if selected_drawer is None:
        print("No closed and unlocked drawer available to open.")
        return

    handle = handles[selected_drawer]

    # Step 3: Pick the handle
    if not robot.is_holding(handle):
        if not robot.is_on_floor(handle):
            print(f"Handle {handle} is not accessible.")
            return
        robot.execute_pick(Object[handle], Object["ready-pose"])

    # Step 4: Pull the drawer open
    robot.execute_pull(selected_drawer, handle, Object["ready-pose"])

def main():
    """Main entry point to slide one drawer open."""
    slide_one_drawer_open()

if __name__ == "__main__":
    main()