"""Module to open one of the drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """Open one of the drawers (generic, any available drawer)."""
    robot = RobotController()

    try:
        # Step 1: If the room is dark, turn on the light
        if robot.is_room_dark():
            robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

        # Step 2: Select an unlocked and closed drawer (generic)
        candidate_drawers = [
            ("drawer_bottom", "handle_bottom"),
            ("drawer_middle", "handle_middle"),
            ("drawer_top", "handle_top"),
        ]
        drawer_to_open = None
        handle_to_use = None
        for drawer_name, handle_name in candidate_drawers:
            if robot.is_drawer_unlocked(drawer_name) and robot.is_drawer_closed(drawer_name):
                drawer_to_open = drawer_name
                handle_to_use = handle_name
                break

        if drawer_to_open is None or handle_to_use is None:
            print("No unlocked and closed drawer available to open.")
            return

        # Step 3: Pick the handle of the selected drawer
        robot.execute_movement(Object[handle_to_use], mode=1, axis=0)

        # Step 4: Pull to open the selected drawer
        robot.execute_movement(Object[handle_to_use], mode=4, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to open one of the drawers."""
    open_one_drawer()

if __name__ == "__main__":
    main()