"""Module to uncover a drawer by opening it, following domain constraints."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to open a drawer, ensuring all domain preconditions are met."""
    robot = RobotController()

    # Step 1: Move to the light switch location and turn on the light if needed
    robot.execute_movement(Object["light_switch"], mode=0)  # Move to light switch
    robot.execute_movement(Object["light_switch"], mode=2)  # Push the switch to turn on the light

    # Step 2: Move to the handle location and pick the handle
    robot.execute_movement(Object["drawer_bottom_handle"], mode=0)  # Move to handle
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # Pick the handle

    # Step 3: Pull the drawer using the handle to open it
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)  # Pull to open

def main():
    """Main entry point to execute the drawer opening sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()