from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """
    Opens any one available drawer.
    """
    robot = RobotController()
    # Choose a drawer to open; here, we select the bottom drawer as an example.
    drawer = "drawer_bottom"
    handle = "handle_bottom"

    # Ensure the room is bright
    if robot.is_room_dark():
        robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Move to the handle location if not already there
    if not robot.is_at_location(Object["drawer-area"]):
        robot.execute_go(Object["ready-pose"], Object["drawer-area"])

    # Pick up the handle if not already holding it
    if not robot.is_holding(Object[handle]):
        if not robot.is_hand_empty():
            robot.release_object()
        robot.execute_pick(Object[handle], Object["drawer-area"])

    # Open the drawer if it is closed and unlocked
    if robot.is_drawer_closed(drawer) and robot.is_drawer_unlocked(drawer):
        robot.execute_pull(Object[drawer + "_handle"], Object[handle], Object["drawer-area"])

def main():
    open_one_drawer()

if __name__ == "__main__":
    main()