"""Module to uncover a drawer by opening it, following PDDL domain preconditions."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to uncover (open) a drawer, ensuring all preconditions are met."""
    robot = RobotController()

    # Step 1: If the room is dark, turn on the light
    if robot.is_room_dark():
        robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Move to the ready-pose location if not already there
    if not robot.is_at_location(Object["ready-pose"]):
        robot.execute_go(robot.get_current_location(), Object["ready-pose"])

    # Step 3: Pick the handle_bottom at ready-pose (execute_pick)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

    # Step 4: Pull to open the drawer_bottom using handle_bottom at ready-pose (execute_pull)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

def main():
    """Main entry point to execute the drawer uncovering task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()