"""Module to open one drawer in a general, abstract way."""
from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """Open any available drawer."""
    robot = RobotController()

    # Ensure the room is bright
    if not robot.is_room_bright():
        switch = next((obj for obj in Object.values() if obj.type == "switch"), None)
        if switch is not None:
            robot.execute_push_switch(switch)
    
    # Find an unlocked, closed drawer and its handle
    for drawer_name, drawer in Object.items():
        if drawer.type == "drawer" and robot.is_drawer_unlocked(drawer) and robot.is_drawer_closed(drawer):
            # Find the handle for this drawer
            handle = next((obj for obj in Object.values() if obj.type == "object" and robot.is_handle_of(obj, drawer)), None)
            if handle is not None:
                # If handle is not held, pick it up
                if not robot.is_holding(handle):
                    if robot.is_on_floor(handle):
                        robot.execute_pick(handle)
                # Pull the drawer open
                robot.execute_pull(drawer, handle)
                break

def main():
    open_one_drawer()

if __name__ == "__main__":
    main()