"""Module to pull open a single drawer with necessary preconditions."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pull open a single drawer, ensuring all preconditions are met."""
    robot = RobotController()
    try:
        # Step 1: If the room is dark, turn on the light
        if robot.is_room_dark():
            robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

        # Step 2: Move to the handle of a closed, unlocked drawer (choose any available)
        drawer_to_open = None
        handle_to_use = None
        for drawer_name, drawer in Object.items():
            if getattr(drawer, "type", None) == "drawer":
                if robot.is_drawer_unlocked(drawer_name) and robot.is_drawer_closed(drawer_name):
                    drawer_to_open = drawer_name
                    # Find corresponding handle
                    for handle_name, handle in Object.items():
                        if getattr(handle, "type", None) == "object":
                            if robot.is_handle_of(handle_name, drawer_name):
                                handle_to_use = handle_name
                                break
                    if handle_to_use:
                        break
        if not drawer_to_open or not handle_to_use:
            print("No suitable drawer and handle found to open.")
            return

        # Step 3: Pick the handle
        robot.execute_movement(Object[handle_to_use], mode=1, axis=0)

        # Step 4: Pull to open the drawer
        robot.execute_movement(Object[handle_to_use], mode=4, axis=0, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()