obs, reward, done = rotate(env, task, target_quat)
# [Frozen Code End]

        # --- Step 2: Move to side position of the chosen drawer ---
        side_pos = chosen_drawer['side_pos']
        try:
            obs, reward, done = move(env, task, side_pos)
            if done:
                print("[Task] Task ended during move to side position!")
                return
        except Exception as e:
            print(f"[Task] Exception during move to side position: {e}")
            return

        # --- Step 3: Move to anchor (handle) position of the drawer ---
        anchor_pos = chosen_drawer['anchor_pos']
        try:
            obs, reward, done = move(env, task, anchor_pos)
            if done:
                print("[Task] Task ended during move to anchor position!")
                return
        except Exception as e:
            print(f"[Task] Exception during move to anchor position: {e}")
            return

        # --- Step 4: Pick the drawer handle (simulate grasp) ---
        # In this domain, the pick-drawer action is abstracted; we simulate by closing the gripper at the anchor position.
        # The 'pick' skill is for objects, not handles, so we skip explicit pick here.

        # --- Step 5: Pull the drawer open ---
        # Pull along +x by a fixed distance (e.g., 0.15m)
        pull_distance = 0.15
        pull_axis = 'x'
        try:
            obs, reward, done = pull(env, task, pull_distance, pull_axis)
            if done:
                print("[Task] Task ended during pull!")
                return
        except Exception as e:
            print(f"[Task] Exception during pull: {e}")
            return

        # --- Step 6: Pick up the rubbish from the table ---
        # Approach from above (z axis)
        try:
            obs, reward, done = pick(env, task, rubbish_pos, approach_distance=0.15, approach_axis='z')
            if done:
                print("[Task] Task ended during pick!")
                return
        except Exception as e:
            print(f"[Task] Exception during pick: {e}")
            return

        # --- Step 7: Place the rubbish into the bin ---
        try:
            obs, reward, done = place(env, task, bin_pos, approach_distance=0.15, approach_axis='z')
            if done:
                print("[Task] Task completed successfully! Reward:", reward)
            else:
                print("[Task] Task not completed yet (done=False).")
        except Exception as e:
            print(f"[Task] Exception during place: {e}")
            return