# ====== Generated Executable Code (after [Frozen Code End]) ======

# Assumptions:
# - The code before [Frozen Code End] has already executed the following steps:
#   1. Move to the side of the drawer (drawer_side)
#   2. Rotate gripper to 90 degrees (quat_90deg)
#   3. Pick (grasp) the drawer handle at anchor position (drawer_anchor)
#   4. Pull the drawer open (pull along x axis)
#   5. Move to a safe position above the drawer (safe_pos)
#
# Now, continue the plan to:
#   - Rotate gripper back to 0 degrees (horizontal for picking tomatoes)
#   - Pick and place all tomatoes (item1, item2, item3) onto the plate

try:
    # === Retrieve object positions ===
    # positions: dict mapping object names to their 3D positions
    positions = get_object_positions()

    # Defensive: Check required objects exist in positions
    required_keys = ['item1', 'item2', 'item3', 'plate',
                     'bottom_side_pos', 'bottom_anchor_pos']
    for key in required_keys:
        if key not in positions:
            print(f"[Error] Required object '{key}' not found in positions dictionary.")
            shutdown_environment(env)
            raise KeyError(f"Missing object position for: {key}")

    # Plate position
    plate_pos = positions['plate']

    # Step 6: Rotate gripper back to 0 degrees (horizontal for picking tomatoes)
    print("[Step 6] Rotate gripper to 0 degrees")
    from scipy.spatial.transform import Rotation as R
    quat_0deg = R.from_euler('z', 0, degrees=True).as_quat()
    obs, reward, done = rotate(
        env, task, target_quat=quat_0deg,
        max_steps=100, threshold=0.05, timeout=10.0
    )
    if done:
        print("[Task] Task ended after rotate to 0 deg!")
        shutdown_environment(env)
        exit()

    # Step 7: Pick the first tomato (item1)
    print("[Step 7] Pick the first tomato (item1)")
    obs, reward, done = pick(
        env, task, target_pos=positions['item1'],
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after picking item1!")
        shutdown_environment(env)
        exit()

    # Step 8: Place the first tomato on the plate
    print("[Step 8] Place the first tomato on the plate")
    obs, reward, done = place(
        env, task, target_pos=plate_pos,
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after placing item1!")
        shutdown_environment(env)
        exit()

    # Step 9: Pick the second tomato (item2)
    print("[Step 9] Pick the second tomato (item2)")
    obs, reward, done = pick(
        env, task, target_pos=positions['item2'],
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after picking item2!")
        shutdown_environment(env)
        exit()

    # Step 10: Place the second tomato on the plate
    print("[Step 10] Place the second tomato on the plate")
    obs, reward, done = place(
        env, task, target_pos=plate_pos,
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after placing item2!")
        shutdown_environment(env)
        exit()

    # Step 11: Pick the third tomato (item3)
    print("[Step 11] Pick the third tomato (item3)")
    obs, reward, done = pick(
        env, task, target_pos=positions['item3'],
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after picking item3!")
        shutdown_environment(env)
        exit()

    # Step 12: Place the third tomato on the plate
    print("[Step 12] Place the third tomato on the plate")
    obs, reward, done = place(
        env, task, target_pos=plate_pos,
        approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0
    )
    if done:
        print("[Task] Task ended after placing item3!")
        shutdown_environment(env)
        exit()

    print("[Task] All tomatoes placed on plate and drawer opened. Task completed successfully!")

finally:
    shutdown_environment(env)