# Step 1: Rotate gripper to 90 degrees (for drawer manipulation)
# [Frozen Code Start]
obs, reward, done = rotate(env, task, target_quat=ninety_deg_quat)
# [Frozen Code End]

# Step 2: Move to side position of bottom drawer
try:
    side_pos = positions.get('bottom_side_pos')
    if side_pos is None:
        raise ValueError("bottom_side_pos not found in positions.")
    obs, reward, done = move(env, task, target_pos=side_pos)
    if done:
        print("[Task] Task ended after move to side!")
        return
except Exception as e:
    print(f"[Error] Move to side failed: {e}")
    shutdown_environment(env)
    return

# Step 3: Move to anchor position of bottom drawer
try:
    anchor_pos = positions.get('bottom_anchor_pos')
    if anchor_pos is None:
        raise ValueError("bottom_anchor_pos not found in positions.")
    obs, reward, done = move(env, task, target_pos=anchor_pos)
    if done:
        print("[Task] Task ended after move to anchor!")
        return
except Exception as e:
    print(f"[Error] Move to anchor failed: {e}")
    shutdown_environment(env)
    return

# Step 4: Pick (grasp) the drawer handle at anchor position
try:
    # For picking the drawer, approach from -z (downward)
    obs, reward, done = pick(env, task, target_pos=anchor_pos, approach_distance=0.10, approach_axis='-z')
    if done:
        print("[Task] Task ended after pick drawer!")
        return
except Exception as e:
    print(f"[Error] Pick drawer failed: {e}")
    shutdown_environment(env)
    return

# Step 5: Pull the drawer open (along x axis, e.g., 0.15m)
try:
    obs, reward, done = pull(env, task, pull_distance=0.15, pull_axis='x')
    if done:
        print("[Task] Task ended after pull!")
        return
except Exception as e:
    print(f"[Error] Pull failed: {e}")
    shutdown_environment(env)
    return

# Step 6: Pick up tomato1 from table
try:
    tomato1_pos = positions.get('tomato1')
    if tomato1_pos is None:
        raise ValueError("tomato1 not found in positions.")
    obs, reward, done = pick(env, task, target_pos=tomato1_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after pick tomato1!")
        return
except Exception as e:
    print(f"[Error] Pick tomato1 failed: {e}")
    shutdown_environment(env)
    return

# Step 7: Place tomato1 on plate
try:
    plate_pos = positions.get('plate')
    if plate_pos is None:
        raise ValueError("plate not found in positions.")
    obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after place tomato1!")
        return
except Exception as e:
    print(f"[Error] Place tomato1 failed: {e}")
    shutdown_environment(env)
    return

# Step 8: Pick up tomato2 from table
try:
    tomato2_pos = positions.get('tomato2')
    if tomato2_pos is None:
        raise ValueError("tomato2 not found in positions.")
    obs, reward, done = pick(env, task, target_pos=tomato2_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after pick tomato2!")
        return
except Exception as e:
    print(f"[Error] Pick tomato2 failed: {e}")
    shutdown_environment(env)
    return

# Step 9: Place tomato2 on plate
try:
    obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after place tomato2!")
        return
except Exception as e:
    print(f"[Error] Place tomato2 failed: {e}")
    shutdown_environment(env)
    return

print("[Task] Task completed successfully! Reward:", reward)