def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'drawer1'
        gripper = 'gripper1'
        object1 = 'object1'
        object2 = 'object2'
        
        # Example positions (replace with actual positions)
        drawer_position = positions[drawer]
        object1_position = positions[object1]
        object2_position = positions[object2]

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, 'initial_room', drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, drawer_position, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to object1
        print("[Task] Moving to object1.")
        obs, reward, done = move(env, drawer_position, object1_position)
        if done:
            print("[Task] Task ended after moving to object1!")
            return

        # Step 5: Pick object1
        print("[Task] Picking object1.")
        obs, reward, done = pick(env, object1, object1_position, gripper)
        if done:
            print("[Task] Task ended after picking object1!")
            return

        # Step 6: Place object1
        print("[Task] Placing object1.")
        obs, reward, done = place(env, object1, 'target_location')
        if done:
            print("[Task] Task ended after placing object1!")
            return

        # Step 7: Move to object2
        print("[Task] Moving to object2.")
        obs, reward, done = move(env, 'target_location', object2_position)
        if done:
            print("[Task] Task ended after moving to object2!")
            return

        # Step 8: Pick object2
        print("[Task] Picking object2.")
        obs, reward, done = pick(env, object2, object2_position, gripper)
        if done:
            print("[Task] Task ended after picking object2!")
            return

        # Step 9: Place object2
        print("[Task] Placing object2.")
        obs, reward, done = place(env, object2, 'final_location')
        if done:
            print("[Task] Task ended after placing object2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()