def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'
        drawer = 'drawer'
        object_to_pick = 'object'  # Replace with actual object name
        room = 'room'  # Replace with actual room name

        # Step 1: Move to the object's location
        object_pos = positions[object_to_pick]
        print(f"[Task] Moving to the position of {object_to_pick} at:", object_pos)
        move(env, room, object_pos)

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_to_pick}.")
        pick(env, object_to_pick, room, gripper)

        # Step 3: Move to the drawer's side position
        side_position = 'side_position'  # Replace with actual side position
        print(f"[Task] Moving to the side position of the drawer.")
        move(env, room, side_position)

        # Step 4: Pick the drawer
        print(f"[Task] Picking the drawer.")
        pick_drawer(env, gripper, drawer, side_position)

        # Step 5: Pull the drawer
        print(f"[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 6: Place the object in the drawer
        print(f"[Task] Placing {object_to_pick} in the drawer.")
        place(env, object_to_pick, drawer)

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()