[Frozen Code Start]

[Frozen Code End]

import numpy as np
from env import setup_environment, shutdown_environment
from video import init_video_writers, recording_step, recording_get_observation
from skill_code import move, rotate, pull, pick, place
from object_positions import get_object_positions

def run_skeleton_task():
    """Execute the oracle plan: unlock bottom drawer and dispose of trash."""
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset environment and wrap for recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve all object positions/orientations
        positions = get_object_positions()
        # Ensure required keys exist
        for key in ['side-pos-bottom','anchor-pos-bottom','ninety_deg','rubbish','bin']:
            if key not in positions:
                raise KeyError(f"Position/orientation for '{key}' not found in get_object_positions().")

        # === Plan Execution ===
        # Step 1: move to side-pos-bottom
        print("[Plan] Step 1: move to side-pos-bottom")
        obs, reward, done = move(env, task, target_pos=np.array(positions['side-pos-bottom']))
        if done:
            print("[Plan] Terminated early after Step 1.")
            return

        # Step 2: rotate to ninety_deg orientation
        print("[Plan] Step 2: rotate to ninety_deg")
        # assume positions['ninety_deg'] yields a quaternion [x,y,z,w]
        obs, reward, done = rotate(env, task, target_quat=np.array(positions['ninety_deg']))
        if done:
            print("[Plan] Terminated early after Step 2.")
            return

        # Step 3: move to anchor-pos-bottom
        print("[Plan] Step 3: move to anchor-pos-bottom")
        obs, reward, done = move(env, task, target_pos=np.array(positions['anchor-pos-bottom']))
        if done:
            print("[Plan] Terminated early after Step 3.")
            return

        # Step 4: pull the drawer handle to open
        print("[Plan] Step 4: pull drawer handle")
        # pull_distance chosen heuristically; adjust if necessary
        obs, reward, done = pull(env, task, pull_distance=0.05, pull_axis='x')
        if done:
            print("[Plan] Terminated early after Step 4.")
            return

        # Step 5: pick up the rubbish on table
        print("[Plan] Step 5: pick rubbish from table")
        # position of the rubbish object
        obs, reward, done = pick(env, task, target_pos=np.array(positions['rubbish']))
        if done:
            print("[Plan] Terminated early after Step 5.")
            return

        # Step 6: move to bin location
        print("[Plan] Step 6: move to bin")
        obs, reward, done = move(env, task, target_pos=np.array(positions['bin']))
        if done:
            print("[Plan] Terminated early after Step 6.")
            return

        # Step 7: place rubbish into bin
        print("[Plan] Step 7: place rubbish into bin")
        obs, reward, done = place(env, task, target_pos=np.array(positions['bin']))
        if done:
            print("[Plan] Completed at Step 7 with done=True. Reward:", reward)
        else:
            print("[Plan] Finished Step 7. Task done flag is False. Reward:", reward)

    except Exception as e:
        print("[Error] Exception during task execution:", str(e))
    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()