[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map keys for readability
        bottom_side_pos   = positions['bottom_side_pos']
        trash_pos         = positions['item3']
        bin_pos           = positions['bin']

        # === Oracle Plan Execution ===
        try:
            # Step 1: Rotate gripper to open-drawer orientation (90 deg)
            print("[Task] Step 1: rotate gripper to 90 degrees")
            # Approximate quaternion for a 90° rotation around X axis
            target_quat = np.array([0.7071, 0.0, 0.0, 0.7071])
            obs, reward, done = rotate(env, task, target_quat)
            if done:
                print("[Task] Terminated during rotate.")
                return

            # Step 2: Move gripper to the side position of the bottom drawer
            print("[Task] Step 2: move to bottom side position")
            obs, reward, done = move(env, task, bottom_side_pos)
            if done:
                print("[Task] Terminated during move to side.")
                return

            # Step 3: Pull the drawer open
            print("[Task] Step 3: pull to open drawer")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Task] Terminated during pull.")
                return

            # Step 4: Move to the trash object
            print("[Task] Step 4: move to trash object")
            obs, reward, done = move(env, task, trash_pos)
            if done:
                print("[Task] Terminated during move to trash.")
                return

            # Step 5: Pick up the trash
            print("[Task] Step 5: pick up trash")
            obs, reward, done = pick(env, task, trash_pos)
            if done:
                print("[Task] Terminated during pick.")
                return

            # Step 6: Move to the bin
            print("[Task] Step 6: move to bin")
            obs, reward, done = move(env, task, bin_pos)
            if done:
                print("[Task] Terminated during move to bin.")
                return

            # Step 7: Place the trash into the bin
            print("[Task] Step 7: place trash into bin")
            obs, reward, done = place(env, task, bin_pos)
            if done:
                print("[Task] Completed place. Reward:", reward)
            else:
                print("[Task] Place finished but done=False. Reward:", reward)

        except Exception as e:
            print(f"[Task] Exception during plan execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()