[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys:
        # 'bottom_side_pos', 'bottom_anchor_pos', 'bottom_joint_pos',
        # 'rubbish', 'bin', etc.
        
        # === Oracle Plan Execution ===
        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: rotate gripper to 90 degrees")
        from scipy.spatial.transform import Rotation as R
        # Create a target quaternion representing a 90° rotation around Z
        quat_90 = R.from_euler('z', 90, degrees=True).as_quat()
        obs, reward, done = rotate(env, task, quat_90)
        if done:
            print("[Task] Finished early after rotate. Reward:", reward)
            return

        # Step 2: Move gripper to side position of bottom drawer
        print("[Task] Step 2: move to bottom side position")
        target_side = positions['bottom_side_pos']
        obs, reward, done = move(env, task, target_side)
        if done:
            print("[Task] Finished early after move-to-side. Reward:", reward)
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        print("[Task] Step 3: move to bottom anchor position")
        target_anchor = positions['bottom_anchor_pos']
        obs, reward, done = move(env, task, target_anchor)
        if done:
            print("[Task] Finished early after move-to-anchor. Reward:", reward)
            return

        # Step 4: Pick the drawer handle (joint) to prepare for pull
        print("[Task] Step 4: pick drawer handle at bottom joint position")
        handle_pos = positions['bottom_joint_pos']
        obs, reward, done = pick(env, task, target_pos=handle_pos, approach_distance=0.10, approach_axis='z')
        if done:
            print("[Task] Finished early after pick-drawer. Reward:", reward)
            return

        # Step 5: Pull drawer open
        print("[Task] Step 5: pull drawer to open")
        # Pull along x-axis by some distance (tunable)
        obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
        if done:
            print("[Task] Finished early after pull. Reward:", reward)
            return

        # Step 6: Pick the rubbish from the table
        print("[Task] Step 6: pick rubbish from table")
        rubbish_pos = positions['rubbish']
        obs, reward, done = pick(env, task, target_pos=rubbish_pos, approach_distance=0.15, approach_axis='z')
        if done:
            print("[Task] Finished early after pick rubbish. Reward:", reward)
            return

        # Step 7: Place the rubbish into the bin
        print("[Task] Step 7: place rubbish into bin")
        bin_pos = positions['bin']
        obs, reward, done = place(env, task, target_pos=bin_pos, approach_distance=0.15, approach_axis='z')
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task ended with done=False. Reward:", reward)

    except Exception as e:
        print("[Task] Exception during execution:", str(e))
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()