[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: Rotate gripper by 90 degrees around Z-axis.")
        # Compute quaternion for 90° around Z (xyzw format)
        quat_90_z = R.from_euler('z', 90, degrees=True).as_quat()
        obs, reward, done = rotate(env, task, quat_90_z)
        if done:
            print("[Task] Early termination during rotate.")
            return

        # Step 2: Move to side position of middle drawer
        side_pos_middle = positions['middle_side_pos']
        print(f"[Task] Step 2: Moving to side position of middle drawer: {side_pos_middle}")
        obs, reward, done = move(env, task, target_pos=side_pos_middle)
        if done:
            print("[Task] Early termination during move-to-side.")
            return

        # Step 3: Move to anchor position of middle drawer
        anchor_pos_middle = positions['middle_anchor_pos']
        print(f"[Task] Step 3: Moving to anchor position of middle drawer: {anchor_pos_middle}")
        obs, reward, done = move(env, task, target_pos=anchor_pos_middle)
        if done:
            print("[Task] Early termination during move-to-anchor.")
            return

        # Step 4: Pick the drawer handle at anchor position
        print(f"[Task] Step 4: Picking drawer handle at: {anchor_pos_middle}")
        obs, reward, done = pick(env, task, target_pos=anchor_pos_middle)
        if done:
            print("[Task] Early termination during pick-drawer.")
            return

        # Step 5: Pull the drawer to open it
        print("[Task] Step 5: Pulling drawer to open it.")
        # Choose a pull distance (meters) and axis - assuming X-axis pulls drawer outward
        pull_distance = 0.2
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Early termination during pull.")
            return

        # Step 6: Pick up the rubbish from the table
        rubbish_pos = positions['rubbish']
        print(f"[Task] Step 6: Picking up rubbish at: {rubbish_pos}")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Early termination during pick (rubbish).")
            return

        # Step 7: Place the rubbish into the bin
        bin_pos = positions['bin']
        print(f"[Task] Step 7: Placing rubbish into bin at: {bin_pos}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Early termination during place (rubbish).")
            return

        # Final status
        if reward is not None:
            print(f"[Task] Completed Oracle Plan. Final reward: {reward}")
        else:
            print("[Task] Completed Oracle Plan. No reward returned.")
        
    except Exception as e:
        print(f"[Task] Exception encountered during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()