[ Frozen Code End ]

    # === Task-Specific Logic ===
    try:
        # Reset task and start recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve all object poses from the environment
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate gripper to ninety_deg")
        target_quat = positions.get('ninety_deg')
        if target_quat is None:
            raise KeyError("Orientation 'ninety_deg' not found in positions")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Plan] Task ended after rotation")
            return

        # Step 2: Move to side position of middle drawer
        print("[Plan] Step 2: move to side-pos-middle")
        side_pos = positions.get('side-pos-middle') or positions.get('middle_side_pos')
        if side_pos is None:
            raise KeyError("Position 'side-pos-middle' not found in positions")
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Plan] Task ended after move-to-side")
            return

        # Step 3: Move to anchor position of middle drawer
        print("[Plan] Step 3: move to anchor-pos-middle")
        anchor_pos = positions.get('anchor-pos-middle') or positions.get('middle_anchor_pos')
        if anchor_pos is None:
            raise KeyError("Position 'anchor-pos-middle' not found in positions")
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Plan] Task ended after move-to-anchor")
            return

        # Step 4: Pick the drawer handle (at the anchor position)
        print("[Plan] Step 4: pick drawer handle")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Plan] Task ended after pick-drawer")
            return

        # Step 5: Pull drawer open
        print("[Plan] Step 5: pull drawer open")
        # Compute pull distance from anchor to joint position
        joint_pos = positions.get('middle_joint_pos')
        if joint_pos is None:
            raise KeyError("Position 'middle_joint_pos' not found in positions")
        pull_distance = float(np.linalg.norm(joint_pos - anchor_pos))
        obs, reward, done = pull(env, task, pull_distance)
        if done:
            print("[Plan] Task ended after pull")
            return

        # Step 6: Pick up any rubbish on the table
        print("[Plan] Step 6: pick rubbish on table")
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            raise KeyError("Position 'rubbish' not found in positions")
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Plan] Task ended after pick(rubbish)")
            return

        # Step 7: Place the rubbish into the bin
        print("[Plan] Step 7: place rubbish into bin")
        bin_pos = positions.get('bin')
        if bin_pos is None:
            raise KeyError("Position 'bin' not found in positions")
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("[Plan] Task completed successfully with final reward:", reward)
        else:
            print("[Plan] Finished plan steps, done flag is False. Reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during plan execution: {e}")
    finally:
        # Ensure environment is always torn down
        shutdown_environment(env)
    print("===== End of Task =====")

if __name__ == "__main__":
    run_skeleton_task()