[Frozen Code Start]
    
[Frozen Code End]

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state and initialize recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        
        # Retrieve object and pose information
        positions = get_object_positions()
        
        # === Step 1: Rotate from zero_deg to ninety_deg ===
        if 'ninety_deg' not in positions:
            raise KeyError("Orientation 'ninety_deg' not found in positions")
        target_quat = positions['ninety_deg']
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        if done:
            print("Task ended after rotate. Reward:", reward)
            return
        
        # === Step 2: Move to side-pos-bottom ===
        if 'side-pos-bottom' not in positions:
            raise KeyError("Position 'side-pos-bottom' not found in positions")
        side_bottom_pos = positions['side-pos-bottom']
        obs, reward, done = move(env, task, target_pos=side_bottom_pos)
        if done:
            print("Task ended after move to side-pos-bottom. Reward:", reward)
            return
        
        # === Step 3: Move to anchor-pos-bottom ===
        if 'anchor-pos-bottom' not in positions:
            raise KeyError("Position 'anchor-pos-bottom' not found in positions")
        anchor_bottom_pos = positions['anchor-pos-bottom']
        obs, reward, done = move(env, task, target_pos=anchor_bottom_pos)
        if done:
            print("Task ended after move to anchor-pos-bottom. Reward:", reward)
            return
        
        # === Step 4: Pull to open bottom drawer ===
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("Task ended after pull. Reward:", reward)
            return
        
        # === Step 5: Pick up the rubbish from the table ===
        if 'rubbish' not in positions:
            raise KeyError("Object 'rubbish' not found in positions")
        rubbish_pos = positions['rubbish']
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("Task ended after pick. Reward:", reward)
            return
        
        # === Step 6: Place the rubbish into the bin ===
        if 'bin' not in positions:
            raise KeyError("Object 'bin' not found in positions")
        bin_pos = positions['bin']
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("Task completed successfully! Final reward:", reward)
        else:
            print("Task did not return done=True. Final reward:", reward)
        
    except Exception as e:
        print("Exception during task execution:", str(e))
    finally:
        # Ensure the environment is always shut down
        shutdown_environment(env)
    
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()