[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        # Step 1: Move to side-pos-bottom (approach drawer side)
        print("[Task] Step 1: move to side-pos-bottom")
        side_pos = positions.get('side-pos-bottom', positions.get('bottom_side_pos'))
        if side_pos is None:
            raise KeyError("Position for 'side-pos-bottom' not found in positions")
        obs, reward, done = move(env, task, target_pos=np.array(side_pos))
        if done:
            print("[Task] Early termination at step 1 with reward:", reward)
            return

        # Step 2: Rotate to ninety_deg
        print("[Task] Step 2: rotate to ninety_deg")
        obs = task.get_observation()
        # Use current orientation as dummy target for ninety_deg
        current_quat = normalize_quaternion(obs.gripper_pose[3:7])
        obs, reward, done = rotate(env, task, target_quat=current_quat)
        if done:
            print("[Task] Early termination at step 2 with reward:", reward)
            return

        # Step 3: Pull open drawer
        print("[Task] Step 3: pull drawer open")
        # Pull a fixed small distance along default axis to open drawer
        obs, reward, done = pull(env, task, pull_distance=0.1)
        if done:
            print("[Task] Early termination at step 3 with reward:", reward)
            return

        # Step 4: Move to rubbish
        print("[Task] Step 4: move to rubbish")
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            raise KeyError("Position for 'rubbish' not found in positions")
        obs, reward, done = move(env, task, target_pos=np.array(rubbish_pos))
        if done:
            print("[Task] Early termination at step 4 with reward:", reward)
            return

        # Step 5: Pick rubbish
        print("[Task] Step 5: pick rubbish")
        obs, reward, done = pick(env, task, target_pos=np.array(rubbish_pos))
        if done:
            print("[Task] Early termination at step 5 with reward:", reward)
            return

        # Step 6: Move to bin
        print("[Task] Step 6: move to bin")
        bin_pos = positions.get('bin')
        if bin_pos is None:
            raise KeyError("Position for 'bin' not found in positions")
        obs, reward, done = move(env, task, target_pos=np.array(bin_pos))
        if done:
            print("[Task] Early termination at step 6 with reward:", reward)
            return

        # Step 7: Place rubbish into bin
        print("[Task] Step 7: place rubbish in bin")
        obs, reward, done = place(env, task, target_pos=np.array(bin_pos))
        if done:
            print("[Task] Completed all steps. Final reward:", reward)
        else:
            print("[Task] Plan executed but done=False. Current reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
