[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        # We only use the predefined skills: rotate, move, pick, pull, place

        # Precompute quaternions for zero and ninety degrees about Z axis
        zero_quat = np.array([0.0, 0.0, 0.0, 1.0])
        ninety_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])

        # Step 1: rotate gripper from zero to 90°
        print("[Plan] Step 1: rotate gripper to 90 degrees")
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("[Plan] Ended early during rotate. Reward:", reward)
            return

        # Step 2: move to the side position of the bottom drawer
        print("[Plan] Step 2: move to bottom_side_pos")
        bottom_side = positions['bottom_side_pos']
        obs, reward, done = move(env, task, np.array(bottom_side))
        if done:
            print("[Plan] Ended early during move to side. Reward:", reward)
            return

        # Step 3: move to the anchor position of the bottom drawer
        print("[Plan] Step 3: move to bottom_anchor_pos")
        bottom_anchor = positions['bottom_anchor_pos']
        obs, reward, done = move(env, task, np.array(bottom_anchor))
        if done:
            print("[Plan] Ended early during move to anchor. Reward:", reward)
            return

        # Step 4: pick the drawer handle (treat handle as generic object)
        print("[Plan] Step 4: pick drawer handle")
        obs, reward, done = pick(env, task, np.array(bottom_anchor))
        if done:
            print("[Plan] Ended early during pick drawer. Reward:", reward)
            return

        # Step 5: pull to open the drawer
        print("[Plan] Step 5: pull to open drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Ended early during pull. Reward:", reward)
            return

        # Step 6: pick the rubbish from the table
        print("[Plan] Step 6: pick rubbish")
        rubbish_pos = positions['rubbish']
        obs, reward, done = pick(env, task, np.array(rubbish_pos))
        if done:
            print("[Plan] Ended early during pick rubbish. Reward:", reward)
            return

        # Step 7: place the rubbish in the bin
        print("[Plan] Step 7: place rubbish in bin")
        bin_pos = positions['bin']
        obs, reward, done = place(env, task, np.array(bin_pos))
        if done:
            print("[Task] Completed successfully! Reward:", reward)
        else:
            print("[Task] Sequence finished but task not flagged done. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
