[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Task-specific implementation that follows the oracle plan.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video recording (optional)
        init_video_writers(obs)

        # Wrap step & get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys: 'bottom_side_pos', 'bottom_anchor_pos', 'rubbish', 'bin', etc.
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # === Execute Oracle Plan ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: Rotate gripper to 90 degrees")
        obs = task.get_observation()
        # Use current orientation as placeholder target (no explicit ninety_deg quaternion available)
        current_quat = normalize_quaternion(obs.gripper_pose[3:7])
        target_quat = current_quat
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Early termination during rotate. Reward:", reward)
            return

        # Step 2: Move to side position of the bottom drawer
        print("[Task] Step 2: Move to side of bottom drawer")
        obs, reward, done = move(env, task, bottom_side_pos)
        if done:
            print("[Task] Early termination during move-to-side. Reward:", reward)
            return

        # Step 3: Move to anchor position of the bottom drawer
        print("[Task] Step 3: Move to anchor of bottom drawer")
        obs, reward, done = move(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Early termination during move-to-anchor. Reward:", reward)
            return

        # Step 4: Pick the drawer handle to prepare for pull
        print("[Task] Step 4: Pick the bottom drawer handle")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Early termination during pick-drawer. Reward:", reward)
            return

        # Step 5: Pull to open the drawer fully
        print("[Task] Step 5: Pull to open drawer")
        # Choose a small pull distance (e.g., 0.1m) along the default axis
        obs, reward, done = pull(env, task, pull_distance=0.1)
        if done:
            print("[Task] Early termination during pull. Reward:", reward)
            return

        # Step 6: Pick up the rubbish from the table
        print("[Task] Step 6: Pick up rubbish")
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Task] Early termination during pick rubbish. Reward:", reward)
            return

        # Step 7: Place the rubbish into the bin
        print("[Task] Step 7: Place rubbish into bin")
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("[Task] Completed successfully! Reward:", reward)
        else:
            print("[Task] Plan finished but done flag is False. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        # Ensure the environment is always shut down
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
