from scipy.spatial.transform import Rotation as R

# === After the Frozen Code Region ===

# Retrieve object positions
positions = get_object_positions()
bottom_side_pos   = np.array(positions['bottom_side_pos'])
bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])
bottom_joint_pos  = np.array(positions['bottom_joint_pos'])
rubbish_pos       = np.array(positions['item3'])
bin_pos           = np.array(positions['bin'])

# === Execute Oracle Plan ===

# Step 1: rotate gripper from zero_deg to ninety_deg
print("[Plan] Step 1: rotate gripper to 90 degrees")
zero_deg_quat   = R.from_euler('z',   0, degrees=True).as_quat()
ninety_deg_quat = R.from_euler('z',  90, degrees=True).as_quat()
obs, reward, done = rotate(env, task, target_quat=ninety_deg_quat)
if done:
    print("[Plan] Task ended during rotate.")
    return

# Step 2: move to side position of bottom drawer
print("[Plan] Step 2: move to bottom side position")
obs, reward, done = move(env, task, target_pos=bottom_side_pos)
if done:
    print("[Plan] Task ended during move to side.")
    return

# Step 3: move to anchor position of bottom drawer
print("[Plan] Step 3: move to bottom anchor position")
obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
if done:
    print("[Plan] Task ended during move to anchor.")
    return

# Step 4: pick the drawer handle
print("[Plan] Step 4: pick drawer handle")
obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
if done:
    print("[Plan] Task ended during pick-drawer.")
    return

# Step 5: pull the drawer open
print("[Plan] Step 5: pull drawer open")
delta = bottom_joint_pos - bottom_anchor_pos
pull_axis = 'x' if delta[0] >= 0 else '-x'
pull_distance = abs(delta[0])
obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
if done:
    print("[Plan] Task ended during pull.")
    return

# Step 6: move to the rubbish object
print("[Plan] Step 6: move to rubbish")
obs, reward, done = move(env, task, target_pos=rubbish_pos)
if done:
    print("[Plan] Task ended during move to rubbish.")
    return

# Step 7: pick up the rubbish
print("[Plan] Step 7: pick rubbish")
obs, reward, done = pick(env, task, target_pos=rubbish_pos)
if done:
    print("[Plan] Task ended during pick rubbish.")
    return

# Step 8: move to the bin location
print("[Plan] Step 8: move to bin")
obs, reward, done = move(env, task, target_pos=bin_pos)
if done:
    print("[Plan] Task ended during move to bin.")
    return

# Step 9: place the rubbish in the bin
print("[Plan] Step 9: place rubbish in bin")
obs, reward, done = place(env, task, target_pos=bin_pos)
if done:
    print("[Plan] Task ended during place rubbish.")
    return

print("[Plan] Completed all steps. Final reward:", reward)