[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Plan Execution ===
        # Step 1: Rotate gripper from zero to ninety degrees
        try:
            print("[Task] Step 1: Rotating gripper to ninety_deg")
            # Assume get_object_positions returns quaternions for these keys
            ninety_quat = positions['ninety_deg']
            obs, reward, done = rotate(env, task, ninety_quat)
            if done:
                print("[Task] Ended after rotation. Reward:", reward)
                return

            # Step 2: Move to side position of bottom drawer
            print("[Task] Step 2: Moving to side position of bottom drawer")
            side_pos_bottom = positions['bottom_side_pos']
            obs, reward, done = move(env, task, side_pos_bottom)
            if done:
                print("[Task] Ended after move-to-side. Reward:", reward)
                return

            # Step 3: Move to anchor position of bottom drawer
            print("[Task] Step 3: Moving to anchor position of bottom drawer")
            anchor_pos_bottom = positions['bottom_anchor_pos']
            obs, reward, done = move(env, task, anchor_pos_bottom)
            if done:
                print("[Task] Ended after move-to-anchor. Reward:", reward)
                return

            # Step 4: Pick the drawer handle at anchor position
            print("[Task] Step 4: Picking drawer handle")
            obs, reward, done = pick(env, task, anchor_pos_bottom)
            if done:
                print("[Task] Ended after pick-drawer. Reward:", reward)
                return

            # Step 5: Pull the drawer open
            print("[Task] Step 5: Pulling drawer open")
            # Use a default pull distance and axis; adjust if needed
            pull_distance = 0.1
            obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
            if done:
                print("[Task] Ended after pull. Reward:", reward)
                return

            # Step 6: Pick up the rubbish from the table
            print("[Task] Step 6: Picking up rubbish from table")
            rubbish_pos = positions['rubbish']
            obs, reward, done = pick(env, task, rubbish_pos)
            if done:
                print("[Task] Ended after pick rubbish. Reward:", reward)
                return

            # Step 7: Place the rubbish into the bin
            print("[Task] Step 7: Placing rubbish into bin")
            bin_pos = positions['bin']
            obs, reward, done = place(env, task, bin_pos)
            if done:
                print("[Task] Completed successfully! Final reward:", reward)
            else:
                print("[Task] Finished all steps, done flag is False. Reward:", reward)

        except Exception as e:
            print("[Task] Error during execution:", str(e))

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()