import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        anchor_pos_bottom = positions.get('bottom_anchor_pos')
        rubbish_pos = positions.get('item3')
        bin_pos = positions.get('bin')

        # === Oracle Plan Execution ===
        # Step 1: Move to the bottom drawer anchor position
        print("[Task] Step 1: Moving to bottom anchor position at", anchor_pos_bottom)
        target_quat = np.array([0.0, 0.0, 0.7071, 0.7071])
        print("[Task] Step 2: Rotating gripper to ninety degrees")
        print("[Task] Step 3: Pulling drawer to open it")
        [Frozen Code Start]
        obs, reward, done = move(env, task, anchor_pos_bottom)
        obs, reward, done = rotate(env, task, target_quat)
        obs, reward, done = pull(env, task, pull_distance=0.1)
        [Frozen Code End]
        if done:
            print("[Task] Ended unexpectedly after opening drawer.")
            return

        # Step 4: Move to the rubbish position
        print("[Task] Step 4: Moving to rubbish at", rubbish_pos)
        obs, reward, done = move(env, task, rubbish_pos)
        if done:
            print("[Task] Ended unexpectedly after move to rubbish.")
            return

        # Step 5: Pick up the rubbish
        print("[Task] Step 5: Picking up the rubbish")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Ended unexpectedly after pick.")
            return

        # Step 6: Move to the bin
        print("[Task] Step 6: Moving to bin at", bin_pos)
        obs, reward, done = move(env, task, bin_pos)
        if done:
            print("[Task] Ended unexpectedly after move to bin.")
            return

        # Step 7: Place the rubbish into the bin
        print("[Task] Step 7: Placing rubbish into bin")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after place. Final reward:", reward)
            return

        print("[Task] Completed all steps. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
        raise

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()