[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Task: Open bottom drawer, then put the rubbish in the bin.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions and Orientations ===
        positions = get_object_positions()
        # We assume get_object_positions returns:
        #   positions['ninety_deg'] as quaternion array [x, y, z, w]
        #   positions['bottom_side_pos'], positions['bottom_anchor_pos'], 
        #   positions['rubbish'], positions['bin'] as 3D np.ndarray

        # === Execute Oracle Plan ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: rotate gripper to ninety_deg")
        ninety_quat = positions['ninety_deg']
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("[Task] Early termination after rotate.")
            return

        # Step 2: Move gripper to side position of bottom drawer
        print("[Task] Step 2: move to bottom side position")
        side_pos = positions['bottom_side_pos']
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Early termination after move-to-side.")
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        print("[Task] Step 3: move to bottom anchor position")
        anchor_pos = positions['bottom_anchor_pos']
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Early termination after move-to-anchor.")
            return

        # Step 4: Grasp the drawer handle (pick-drawer)
        print("[Task] Step 4: grasp drawer handle")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Early termination after pick-drawer.")
            return

        # Step 5: Pull drawer open
        print("[Task] Step 5: pull drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Early termination after pull.")
            return

        # Step 6: Pick up the rubbish from the table
        print("[Task] Step 6: pick rubbish")
        rubbish_pos = positions['rubbish']
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Task] Early termination after pick rubbish.")
            return

        # Step 7: Place the rubbish into the bin
        print("[Task] Step 7: place rubbish in bin")
        bin_pos = positions['bin']
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task finished but done flag is False. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()